<?php
// Exit if accessed directly
if( ! defined( 'ABSPATH' ) ) exit;

/**
 * My Profile Widget
 *
 * @since 0.1
 */
class Pixad_Auto_Widget_By_Make extends WP_Widget {
	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct( 'pixad_auto_widget_by_make', __( 'Auto: By Make', 'pixautodeal' ), array( 'description' => __( 'Filter autos by make.', 'pixautodeal' ), ) );
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		global $post;

        $type = isset($instance['type']) && $instance['type'] == 'select' ? 'jelect' : 'check';

		?>
		<section class="widget block_content widget_mod-a pixad-filter" data-type="<?php echo esc_attr($type); ?>" data-field="make">
		<?php if( empty( $args['before_title'] ) ): ?>
			<h3 class="widget-title">
			<span>
		<?php endif; ?>

		<?php
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'].apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
		?>

		<?php if( empty( $args['before_title'] ) ): ?>
			</span>
			</h3>
			<div class="decor-1"></div>
		<?php endif; ?>

		<div class="widget-content">

			<?php
			$args_tax = array(
				'taxonomy'      => array( 'auto-model' ),
				'orderby'       => 'name',
				'order'         => 'ASC',
				'parent'        => '0',
				'hide_empty'    => '0',

			);
			$autos_categories = get_categories ($args_tax);

			if( isset($instance['type']) && $instance['type'] == 'select') {
			    $all_make_class = !isset($_REQUEST['make']) ? 'jelect-option_state_active' : '';
			    $all_model_class = !isset($_REQUEST['model']) ? 'jelect-option_state_active' : '';
			    $out_make  = __( 'All Makes', 'pixautodeal');
			    $out_model = __( 'All Models', 'pixautodeal');
			    $out_makes = $out_models = '';
			    $get_make = isset($_REQUEST['make']) ? explode(',', $_REQUEST['make']) : array();
			    $get_model = isset($_REQUEST['model']) ? explode(',', $_REQUEST['model']) : array();

                foreach ($autos_categories as $auto_cat) :
                    if( in_array($auto_cat->slug, $get_make) ){
                        $class_make = 'jelect-option_state_active';
                        $out_make = $auto_cat->name;
                    } else {
                        $class_make = '';
                    }
                    $out_makes .= '<li data-val="'.esc_attr($auto_cat->slug).'" class="jelect-option '.esc_attr($class_make).'">'.wp_kses_post($auto_cat->name).'</li>';
                endforeach;
            ?>
                <div  class="select select_mod-a jelect pixad-makes-models-select">
                    <input data-type="jelect" data-field="make" id="ajax-make" name="ajax-make" value="" data-text="imagemin" type="text" class="jelect-input">
                    <div tabindex="0" role="button" class="jelect-current"><?php echo wp_kses_post($out_make) ?></div>
                    <ul class="jelect-options">
                        <li data-val="" class="jelect-option <?php echo esc_attr($all_make_class) ?>"><?php _e( 'All Makes', 'pixautodeal') ?></li>
                        <?php echo ($out_makes) ?>
                    </ul>
                </div>
                <?php
                if(!empty($get_make)){
                    $make_term = get_term_by('slug', $get_make[0], 'auto-model');
                    $args = array(
                        'taxonomy'      => 'auto-model',
                        'orderby'       => 'name',
                        'order'         => 'ASC',
                        'parent'        => $make_term->term_id,
                        'hide_empty'    => false,
                    );
                    $terms_arr = get_terms( $args );
                    foreach ($terms_arr as $k => $v) {
                        if( in_array($v->slug, $get_model) ){
                            $class_model = 'jelect-option_state_active';
                            $out_model = $v->name;
                        } else {
                            $class_model = '';
                        }
                        $out_models .= '<li data-val="'.esc_attr($v->slug).'" class="jelect-option '.esc_attr($class_model).'">'.wp_kses_post($v->name).'</li>';
                    }
                }
                ?>
                <div class="select select_mod-a jelect">
                    <input data-type="jelect" data-field="model" id="pixad-model" name="pixad-model" value="" data-text="imagemin" type="text" class="jelect-input">
                    <input type="hidden" class="pixad-model-default-hidden" value="<?php esc_attr_e( 'All Models', 'pixautodeal') ?>">
                    <div tabindex="0" role="button" class="jelect-current pixad-model"><?php echo wp_kses_post($out_model) ?></div>
                    <ul class="jelect-options pixad-model">
                        <li data-val="" class="jelect-option <?php echo esc_attr($all_model_class) ?>"><?php _e( 'All Models', 'pixautodeal') ?></li>
                        <?php echo ($out_models) ?>
                    </ul>
                </div>
			<?php
            } else {
				$autos_categories = get_categories ($args_tax);
                if ($autos_categories):
                    echo '<ul class="list-categories list-unstyled">';
                    $get_make = isset($_REQUEST['make']) ? explode(',', $_REQUEST['make']) : array();
                    foreach ($autos_categories as $auto_cat) :
                        ?>
                        <li class="list-categories__item">
                            <input data-type="check" data-field="make"
                                   type="checkbox" <?php echo in_array($auto_cat->slug, $get_make) ? 'checked' : ''; ?>
                                   name="pixad-make" id="<?php echo esc_attr($auto_cat->slug) ?>"
                                   value="<?php echo esc_attr($auto_cat->slug) ?>">
                            <label for="<?php echo esc_attr($auto_cat->slug) ?>"><?php echo wp_kses_post($auto_cat->name) ?></label>
                        </li>
                        <?php
                        $args_tax_sub = array(
							'taxonomy'      => array( 'auto-model' ),
							'child_of'      => $auto_cat->term_id,
							'hide_empty'    => '0',
						);
						$autos_categories_sub = get_categories ($args_tax_sub);
						if ($autos_categories_sub):
							echo '<ul class="list-categories sub-categories list-unstyled">';
							foreach ($autos_categories_sub as $auto_cat_sub) :
							?>
							<li class="list-categories__item">
								<input data-type="check" data-field="make"
									   type="checkbox" <?php echo in_array($auto_cat_sub->slug, $get_make) ? 'checked' : ''; ?>
									   name="pixad-make" id="<?php echo esc_attr($auto_cat_sub->slug) ?>"
									   value="<?php echo esc_attr($auto_cat_sub->slug) ?>">
								<label for="<?php echo esc_attr($auto_cat_sub->slug) ?>"><?php echo wp_kses_post($auto_cat_sub->name) ?></label>
							</li>
							<?php
							endforeach;
							echo '</ul>';
						endif;
                    endforeach;
                    echo '</ul>';
                    //echo '<a class="list-categories__more" href="javascript:void(0);">'.__( 'VIEW MORE', 'pixautodeal' ).'</a>';
                endif;
            }
			?>

		</div>
		</section>
		<?php

	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$title = isset( $instance['title'] ) ? $instance['title'] : __( 'By Make', 'pixautodeal' );
		$type = isset( $instance['type'] ) ? $instance['type'] : 'list';

		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'pixautodeal' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'type' ); ?>"><?php _e( 'Filter Type:', 'pixautodeal' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'type' ); ?>" name="<?php echo $this->get_field_name( 'type' ); ?>">
                <option value="list" <?php selected( $type, 'list', true ); ?>><?php _e( 'List of makes', 'pixautodeal' ); ?></option>
                <option value="select" <?php selected( $type, 'select', true ); ?>><?php _e( 'Makes and models selects', 'pixautodeal' ); ?></option>
            </select>
		</p>
		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['type'] = ( ! empty( $new_instance['type'] ) ) ? strip_tags( $new_instance['type'] ) : 'list';

		return $instance;
	}
}

class Pixad_Auto_Widget_Year_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_year_filter', __( 'Auto: Year Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by year.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
			<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="autoyear">
		<?php
			if (!empty($instance['year_title'])) {
				echo $before_title . apply_filters('widget_title', $instance['year_title']) . $after_title;
				$get_year = isset($_REQUEST['autoyear']) ? explode(',',$_REQUEST['autoyear']) : array();
			}
			?>
				<div class="widget-content">
					<div class="slider-price" id="slider-year"></div>
					<span class="slider-price__wrap-input">
						<input data-type="number" data-field="autoyear" class="slider-price__input" id="slider-year_min" name="pixad-autoyear">
						<span>-</span>
						<input data-type="number" data-field="autoyear" class="slider-price__input" id="slider-year_max" name="pixad-autoyear">
						<input type="hidden" id="pix-min-year" value="<?php echo isset($get_year[0]) ? esc_attr($get_year[0]) : ''; ?>">
						<input type="hidden" id="pix-max-year" value="<?php echo isset($get_year[1]) ? esc_attr($get_year[1]) : ''; ?>">
						<input type="hidden" id="pix-max-slider-year" value="<?php echo esc_attr(date('Y')) ?>">
					</span>
				</div>
			</section>
		<?php

	}

	public function form( $instance ) {
		$year_title = ! empty( $instance['year_title'] ) ? $instance['year_title'] : __( 'Year Range', 'pixautodeal' );

		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'year_title' ); ?>"><?php _e( 'Year Range Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'year_title' ); ?>" name="<?php echo $this->get_field_name( 'year_title' ); ?>" type="text" value="<?php echo esc_attr( $year_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {

		$instance = array();

		$instance['year_title'] = ( ! empty( $new_instance['year_title'] ) ) ? strip_tags( $new_instance['year_title'] ) : '';

		return $instance;
	}
}

class Pixad_Auto_Widget_Price_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_price_filter', __( 'Auto: Price Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by price.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$Settings	= new PIXAD_Settings();
		$settings	= $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_settings', true );
		$currency = pixad_get_currencies($settings['autos_site_currency']);
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
			<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="price">
			<?php
				if (!empty($instance['price_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['price_title']) . $after_title;
					$get_price = isset($_REQUEST['price']) ? explode(',',$_REQUEST['price']) : array();
				}
            ?>
				<div class="widget-content">
					<div class="slider-price" id="slider-price"></div>
					<span class="slider-price__wrap-input">
						<input data-type="number" data-field="price" class="slider-price__input" id="slider-price_min" name="pixad-price">
						<span>-</span>
						<input data-type="number" data-field="price" class="slider-price__input" id="slider-price_max" name="pixad-price">
						<input type="hidden" id="pix-min-price" value="<?php echo isset($get_price[0]) ? esc_attr($get_price[0]) : ''; ?>">
						<input type="hidden" id="pix-max-price" value="<?php echo isset($get_price[1]) ? esc_attr($get_price[1]) : ''; ?>">
						<input type="hidden" id="pix-max-slider-price" value="<?php echo esc_attr($settings['autos_max_price']) ?>">
						<input type="hidden" id="pix-currency-symbol" value="<?php echo esc_attr($currency['symbol']) ?>">
					</span>
				</div>
			</section>
		<?php

	}

	public function form( $instance ) {
		$price_title = ! empty( $instance['price_title'] ) ? $instance['price_title'] : __( 'Price Range', 'pixautodeal' );

		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'price_title' ); ?>"><?php _e( 'Price Block Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'price_title' ); ?>" name="<?php echo $this->get_field_name( 'price_title' ); ?>" type="text" value="<?php echo esc_attr( $price_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {

		$instance = array();

		$instance['price_title'] = ( ! empty( $new_instance['price_title'] ) ) ? strip_tags( $new_instance['price_title'] ) : '';

		return $instance;
	}
}

class Pixad_Auto_Widget_Body_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_body_filter', __( 'Auto: Body Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by body.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
			<section class="widget block_content widget_mod-a pixad-filter" data-type="check" data-field="body">
			<?php
				if (!empty($instance['body_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['body_title']) . $after_title;
				}
				$args_tax = array( 'taxonomy' => 'auto-body', 'hide_empty' => '1');
				$autos_bodies = get_categories ($args_tax);
				if( $autos_bodies ):
					$get_body = isset($_REQUEST['body']) ? explode(',',$_REQUEST['body']) : array();
					echo '<div class="widget-content">
							<ul class="list-categories list-unstyled">';
					foreach($autos_bodies as $auto_body) :
						?>
						<li class="list-categories__item">
							<input data-type="check" data-field="body" type="checkbox" <?php echo in_array($auto_body->slug, $get_body) ? 'checked' : ''; ?> name="pixad-body" id="<?php echo esc_attr($auto_body->slug) ?>" value="<?php echo esc_attr($auto_body->slug) ?>">
							<label for="<?php echo esc_attr($auto_body->slug) ?>"><?php echo wp_kses_post($auto_body->name) ?></label>
						</li>
						<?php
					endforeach;
					echo '</ul>
					</div>';
				endif;
				?>
				</section>
		<?php

	}

	public function form( $instance ) {
		$body_title = ! empty( $instance['body_title'] ) ? $instance['body_title'] : __( 'Vehicle Body Type', 'pixautodeal' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'body_title' ); ?>"><?php _e( 'Vehicle Body Type Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'body_title' ); ?>" name="<?php echo $this->get_field_name( 'body_title' ); ?>" type="text" value="<?php echo esc_attr( $body_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['body_title'] = ( ! empty( $new_instance['body_title'] ) ) ? strip_tags( $new_instance['body_title'] ) : '';
		return $instance;
	}
}

class Pixad_Auto_Widget_Fuel_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_fuel_filter', __( 'Auto: Fuel Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by fuel.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
			<section class="widget block_content widget_mod-a pixad-filter" data-type="jelect" data-field="fuel">
			<?php
			if (!empty($instance['fuel_title'])) {
				echo $before_title . apply_filters('widget_title', $instance['fuel_title']) . $after_title;
			}
			?>
				<div class="widget-content">
					<div  class="select select_mod-a jelect">
						<input data-type="jelect" data-field="fuel" id="pixad-fuel" name="pixad-fuel" value="" data-text="imagemin" type="text" class="jelect-input">
						<div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Fuel Types', 'pixautodeal') ?></div>
						<ul class="jelect-options">
							<li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Fuel Types', 'pixautodeal') ?></li>
							<li data-val="petrol" class="jelect-option"><?php esc_html_e( 'Petrol', 'pixautodeal') ?></li>
							<li data-val="diesel" class="jelect-option"><?php esc_html_e( 'Diesel', 'pixautodeal') ?></li>
							<li data-val="hybrid" class="jelect-option"><?php esc_html_e( 'Hybrid', 'pixautodeal') ?></li>
							<li data-val="electric" class="jelect-option"><?php esc_html_e( 'Electric', 'pixautodeal') ?></li>
						</ul>
					</div>
				</div>
			</section>
		<?php

	}

	public function form( $instance ) {
		$fuel_title = ! empty( $instance['fuel_title'] ) ? $instance['fuel_title'] : __( 'Fuel Type', 'pixautodeal' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'fuel_title' ); ?>"><?php _e( 'Fuel Type Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'fuel_title' ); ?>" name="<?php echo $this->get_field_name( 'fuel_title' ); ?>" type="text" value="<?php echo esc_attr( $fuel_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['fuel_title'] = ( ! empty( $new_instance['fuel_title'] ) ) ? strip_tags( $new_instance['fuel_title'] ) : '';
		return $instance;
	}
}

class Pixad_Auto_Widget_Transmission_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_transmission_filter', __( 'Auto: Transmission Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by transmission.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
			<section class="widget block_content widget_mod-a pixad-filter" data-type="jelect" data-field="transmission">
			<?php
			if (!empty($instance['transmission_title'])) {
				echo $before_title . apply_filters('widget_title', $instance['transmission_title']) . $after_title;
			}
			?>
				<div class="widget-content">
					<div  class="select select_mod-a jelect">
						<input data-type="jelect" data-field="transmission" id="pixad-transmission" name="pixad-transmission" value="" data-text="imagemin" type="text" class="jelect-input">
						<div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Transmissions', 'pixautodeal') ?></div>
						<ul class="jelect-options">
							<li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Transmissions', 'pixautodeal') ?></li>
							<li data-val="automatic" class="jelect-option"><?php esc_html_e( 'Automatic', 'pixautodeal') ?></li>
							<li data-val="manual" class="jelect-option"><?php esc_html_e( 'Manual', 'pixautodeal') ?></li>
							<li data-val="semi-automatic" class="jelect-option"><?php esc_html_e( 'Semi-Automatic', 'pixautodeal') ?></li>
						</ul>
					</div>
				</div>
			</section>
		<?php

	}

	public function form( $instance ) {
		$transmission_title = ! empty( $instance['transmission_title'] ) ? $instance['transmission_title'] : __( 'Transmission Type', 'pixautodeal' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'transmission_title' ); ?>"><?php _e( 'Transmission Type Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'transmission_title' ); ?>" name="<?php echo $this->get_field_name( 'transmission_title' ); ?>" type="text" value="<?php echo esc_attr( $transmission_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['transmission_title'] = ( ! empty( $new_instance['transmission_title'] ) ) ? strip_tags( $new_instance['transmission_title'] ) : '';
		return $instance;
	}
}

class Pixad_Auto_Widget_Mileage_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_mileage_filter', __( 'Auto: Mileage Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by mileage.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
			<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="mileage">
			<?php
			if (!empty($instance['mileage_title'])) {
				echo $before_title . apply_filters('widget_title', $instance['mileage_title']) . $after_title;
				$get_mileage = isset($_REQUEST['mileage']) ? explode(',',$_REQUEST['mileage']) : array();
			}
			?>
				<div class="widget-content">
					<div class="slider-price" id="slider-mileage"></div>
					<span class="slider-price__wrap-input">
						<input data-type="number" data-field="mileage" class="slider-price__input" id="slider-mileage_min" name="pixad-mileage">
						<span>-</span>
						<input data-type="number" data-field="mileage" class="slider-price__input" id="slider-mileage_max" name="pixad-mileage">
						<input type="hidden" id="pix-min-mileage" value="<?php echo isset($get_mileage[0]) ? esc_attr($get_mileage[0]) : ''; ?>">
						<input type="hidden" id="pix-max-mileage" value="<?php echo isset($get_mileage[1]) ? esc_attr($get_mileage[1]) : ''; ?>">
						<input type="hidden" id="pix-max-slider-mileage" value="500000">
					</span>
				</div>
			</section>
		<?php

	}

	public function form( $instance ) {
		$mileage_title = ! empty( $instance['mileage_title'] ) ? $instance['mileage_title'] : __( 'Mileage Range', 'pixautodeal' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'mileage_title' ); ?>"><?php _e( 'Mileage Range Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'mileage_title' ); ?>" name="<?php echo $this->get_field_name( 'mileage_title' ); ?>" type="text" value="<?php echo esc_attr( $mileage_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['mileage_title'] = ( ! empty( $new_instance['mileage_title'] ) ) ? strip_tags( $new_instance['mileage_title'] ) : '';
		return $instance;
	}
}

class Pixad_Auto_Widget_Engine_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_engine_filter', __( 'Auto: Engine Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by engine.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
			<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="engine">
			<?php
			if (!empty($instance['engine_title'])) {
				echo $before_title . apply_filters('widget_title', $instance['engine_title']) . $after_title;
				$get_engine = isset($_REQUEST['engine']) ? explode(',',$_REQUEST['engine']) : array();
			}
			?>
				<div class="widget-content">
					<div class="slider-price" id="slider-engine"></div>
					<span class="slider-price__wrap-input">
						<input data-type="number" data-field="engine" class="slider-price__input" id="slider-engine_min" name="pixad-engine">
						<span>-</span>
						<input data-type="number" data-field="engine" class="slider-price__input" id="slider-engine_max" name="pixad-engine">
						<input type="hidden" id="pix-min-engine" value="<?php echo isset($get_engine[0]) ? esc_attr($get_engine[0]) : ''; ?>">
						<input type="hidden" id="pix-max-engine" value="<?php echo isset($get_engine[1]) ? esc_attr($get_engine[1]) : ''; ?>">
						<input type="hidden" id="pix-max-slider-engine" value="7">
					</span>
				</div>
			</section>
		<?php

	}

	public function form( $instance ) {
		$engine_title = ! empty( $instance['engine_title'] ) ? $instance['engine_title'] : __( 'Engine Volume', 'pixautodeal' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'engine_title' ); ?>"><?php _e( 'Engine Volume Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'engine_title' ); ?>" name="<?php echo $this->get_field_name( 'engine_title' ); ?>" type="text" value="<?php echo esc_attr( $engine_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['engine_title'] = ( ! empty( $new_instance['engine_title'] ) ) ? strip_tags( $new_instance['engine_title'] ) : '';
		return $instance;
	}
}

class Pixad_Auto_Widget_Condition_Filter extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_condition_filter', __( 'Auto: Condition Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by condition.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];

		?>
		<section class="widget block_content widget_mod-a pixad-filter" data-type="jelect" data-field="condition">
		<?php
		if (!empty($instance['condition_title'])) {
			echo $before_title . apply_filters('widget_title', $instance['condition_title']) . $after_title;
		}
		?>
			<div class="widget-content">
				<div  class="select select_mod-a jelect">
					<input data-type="jelect" data-field="condition" id="pixad-condition" name="pixad-condition" value="" data-text="imagemin" type="text" class="jelect-input">
					<div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Conditions', 'pixautodeal') ?></div>
					<ul class="jelect-options">
						<li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Conditions', 'pixautodeal') ?></li>
						<li data-val="new" class="jelect-option"><?php esc_html_e( 'New', 'pixautodeal') ?></li>
						<li data-val="used" class="jelect-option"><?php esc_html_e( 'Used', 'pixautodeal') ?></li>
						<li data-val="driver" class="jelect-option"><?php esc_html_e( 'Driver', 'pixautodeal') ?></li>
						<li data-val="non driver" class="jelect-option"><?php esc_html_e( 'Non driver', 'pixautodeal') ?></li>
						<li data-val="projectcar" class="jelect-option"><?php esc_html_e( 'Projectcar', 'pixautodeal') ?></li>
						<li data-val="barnfind" class="jelect-option"><?php esc_html_e( 'Barnfind', 'pixautodeal') ?></li>
					</ul>
				</div>
			</div>
		</section>
		<?php

	}

	public function form( $instance ) {
		$condition_title = ! empty( $instance['condition_title'] ) ? $instance['condition_title'] : __( 'Auto Condition', 'pixautodeal' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'condition_title' ); ?>"><?php _e( 'Condition Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'condition_title' ); ?>" name="<?php echo $this->get_field_name( 'condition_title' ); ?>" type="text" value="<?php echo esc_attr( $condition_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['condition_title'] = ( ! empty( $new_instance['condition_title'] ) ) ? strip_tags( $new_instance['condition_title'] ) : '';
		return $instance;
	}
}

class Pixad_Auto_Widget_Reset_Button extends WP_Widget {

	function __construct() {
		parent::__construct( 'pixad_auto_widget_reset_button', __( 'Auto: Reset Button', 'pixautodeal' ), array( 'description' => __( 'Reset all filters.', 'pixautodeal' ), ) );
	}

	public function widget( $args, $instance ) {
		?>
		<div class="btn">
			<div class="btn-filter wrap__btn-skew-r js-filter">
				<?php
					$path = '';
					if(substr_count($_SERVER['REQUEST_URI'], '/page/') > 0){
						$path = preg_split('/\/page\//', $_SERVER['REQUEST_URI']);
						$path = $path[0].'/';
					}else{
						$path = preg_split('/\?/', $_SERVER['REQUEST_URI']);
						$path = $path[0];
					}
				?>
				<button data-href="<?php echo esc_url($_SERVER['SERVER_NAME'] . $path)?>" id="pixad-reset-button" class="btn-skew-r btn-effect"><span class="btn-skew-r__inner"><?php echo wp_kses_post($instance['btn_title']) ?></span></button>

			</div>
		</div>
		<?php

	}

	public function form( $instance ) {
		$btn_title = ! empty( $instance['btn_title'] ) ? $instance['btn_title'] : __( 'Reset', 'pixautodeal' );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'btn_title' ); ?>"><?php _e( 'Button Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'btn_title' ); ?>" name="<?php echo $this->get_field_name( 'btn_title' ); ?>" type="text" value="<?php echo esc_attr( $btn_title ); ?>">
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['btn_title'] = ( ! empty( $new_instance['btn_title'] ) ) ? strip_tags( $new_instance['btn_title'] ) : '';
		return $instance;
	}
}

class Pixad_Auto_Widget_Filter extends WP_Widget {
	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct( 'pixad_auto_widget_filter', __( 'Auto: Filter', 'pixautodeal' ), array( 'description' => __( 'Filter autos by price, body type, fuel, transmission.', 'pixautodeal' ), ) );
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		global $post;
		$Settings	= new PIXAD_Settings();
		$settings	= $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_settings', true );
		$currency = pixad_get_currencies($settings['autos_site_currency']);
		$before_title = $args['before_title'];
		$after_title = $args['after_title'];
		?>
		<div class="wrap-filter">
		    <?php
			if($instance['year']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="autoyear">
			<?php
				if (!empty($instance['year_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['year_title']) . $after_title;
					$get_year = isset($_REQUEST['autoyear']) ? explode(',',$_REQUEST['autoyear']) : array();
				}
				?>
					<div class="widget-content">
						<div class="slider-price" id="slider-year"></div>
						<span class="slider-price__wrap-input">
							<input data-type="number" data-field="autoyear" class="slider-price__input" id="slider-year_min" name="pixad-autoyear">
							<span>-</span>
							<input data-type="number" data-field="autoyear" class="slider-price__input" id="slider-year_max" name="pixad-autoyear">
							<input type="hidden" id="pix-min-year" value="<?php echo isset($get_year[0]) ? esc_attr($get_year[0]) : ''; ?>">
							<input type="hidden" id="pix-max-year" value="<?php echo isset($get_year[1]) ? esc_attr($get_year[1]) : ''; ?>">
							<input type="hidden" id="pix-max-slider-year" value="<?php echo esc_attr(date('Y')) ?>">
						</span>
					</div>
				</section>
			<?php
			}
			?>
			<?php
			if($instance['price']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="price">
			<?php
				if (!empty($instance['price_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['price_title']) . $after_title;
					$get_price = isset($_REQUEST['price']) ? explode(',',$_REQUEST['price']) : array();
				}
            ?>
					<div class="widget-content">
						<div class="slider-price" id="slider-price"></div>
						<span class="slider-price__wrap-input">
							<input data-type="number" data-field="price" class="slider-price__input" id="slider-price_min" name="pixad-price">
							<span>-</span>
							<input data-type="number" data-field="price" class="slider-price__input" id="slider-price_max" name="pixad-price">
							<input type="hidden" id="pix-min-price" value="<?php echo isset($get_price[0]) ? esc_attr($get_price[0]) : ''; ?>">
							<input type="hidden" id="pix-max-price" value="<?php echo isset($get_price[1]) ? esc_attr($get_price[1]) : ''; ?>">
							<input type="hidden" id="pix-max-slider-price" value="<?php echo esc_attr($settings['autos_max_price']) ?>">
							<input type="hidden" id="pix-currency-symbol" value="<?php echo esc_attr($currency['symbol']) ?>">
						</span>
					</div>
				</section>
			<?php
			}
			?>
			<?php
			if($instance['body']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="check" data-field="body">
			<?php
				if (!empty($instance['body_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['body_title']) . $after_title;
				}
				$args_tax = array( 'taxonomy' => 'auto-body', 'hide_empty' => '1');
				$autos_bodies = get_categories ($args_tax);
				if( $autos_bodies ):
					$get_body = isset($_REQUEST['body']) ? explode(',',$_REQUEST['body']) : array();
					echo '<div class="widget-content">
							<ul class="list-categories list-unstyled">';
					foreach($autos_bodies as $auto_body) :
						?>
						<li class="list-categories__item">
							<input data-type="check" data-field="body" type="checkbox" <?php echo in_array($auto_body->slug, $get_body) ? 'checked' : ''; ?> name="pixad-body" id="<?php echo esc_attr($auto_body->slug) ?>" value="<?php echo esc_attr($auto_body->slug) ?>">
							<label for="<?php echo esc_attr($auto_body->slug) ?>"><?php echo wp_kses_post($auto_body->name) ?></label>
						</li>
						<?php
					endforeach;
					echo '</ul>
					</div>';
				endif;
				?>
				</section>
			<?php
			}
			?>
			<?php
			if($instance['fuel']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="jelect" data-field="fuel">
			<?php
				if (!empty($instance['fuel_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['fuel_title']) . $after_title;
				}
				?>
					<div class="widget-content">
						<div  class="select select_mod-a jelect">
							<input data-type="jelect" data-field="fuel" id="pixad-fuel" name="pixad-fuel" value="" data-text="imagemin" type="text" class="jelect-input">
							<div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Fuel Types', 'pixautodeal') ?></div>
							<ul class="jelect-options">
								<li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Fuel Types', 'pixautodeal') ?></li>
								<li data-val="petrol" class="jelect-option"><?php esc_html_e( 'Petrol', 'pixautodeal') ?></li>
								<li data-val="diesel" class="jelect-option"><?php esc_html_e( 'Diesel', 'pixautodeal') ?></li>
								<li data-val="hybrid" class="jelect-option"><?php esc_html_e( 'Hybrid', 'pixautodeal') ?></li>
								<li data-val="electric" class="jelect-option"><?php esc_html_e( 'Electric', 'pixautodeal') ?></li>
							</ul>
						</div>
					</div>
				</section>
			<?php
			}
			?>
			<?php
			if($instance['transmission']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="jelect" data-field="transmission">
			<?php
				if (!empty($instance['transmission_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['transmission_title']) . $after_title;
				}
				?>
					<div class="widget-content">
						<div  class="select select_mod-a jelect">
							<input data-type="jelect" data-field="transmission" id="pixad-transmission" name="pixad-transmission" value="" data-text="imagemin" type="text" class="jelect-input">
							<div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Transmissions', 'pixautodeal') ?></div>
							<ul class="jelect-options">
								<li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Transmissions', 'pixautodeal') ?></li>
								<li data-val="automatic" class="jelect-option"><?php esc_html_e( 'Automatic', 'pixautodeal') ?></li>
								<li data-val="manual" class="jelect-option"><?php esc_html_e( 'Manual', 'pixautodeal') ?></li>
								<li data-val="semi-automatic" class="jelect-option"><?php esc_html_e( 'Semi-Automatic', 'pixautodeal') ?></li>
							</ul>
						</div>
					</div>
				</section>
			<?php
			}
			?>

			<?php
			if($instance['mileage']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="mileage">
			<?php
				if (!empty($instance['mileage_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['mileage_title']) . $after_title;
					$get_mileage = isset($_REQUEST['mileage']) ? explode(',',$_REQUEST['mileage']) : array();
				}
				?>
					<div class="widget-content">
						<div class="slider-price" id="slider-mileage"></div>
						<span class="slider-price__wrap-input">
							<input data-type="number" data-field="mileage" class="slider-price__input" id="slider-mileage_min" name="pixad-mileage">
							<span>-</span>
							<input data-type="number" data-field="mileage" class="slider-price__input" id="slider-mileage_max" name="pixad-mileage">
							<input type="hidden" id="pix-min-mileage" value="<?php echo isset($get_mileage[0]) ? esc_attr($get_mileage[0]) : ''; ?>">
							<input type="hidden" id="pix-max-mileage" value="<?php echo isset($get_mileage[1]) ? esc_attr($get_mileage[1]) : ''; ?>">
							<input type="hidden" id="pix-max-slider-mileage" value="500000">
						</span>
					</div>
				</section>
			<?php
			}
			?>

			<?php
			if($instance['engine']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="number" data-field="engine">
			<?php
				if (!empty($instance['engine_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['engine_title']) . $after_title;
					$get_engine = isset($_REQUEST['engine']) ? explode(',',$_REQUEST['engine']) : array();
				}
				?>
					<div class="widget-content">
						<div class="slider-price" id="slider-engine"></div>
						<span class="slider-price__wrap-input">
							<input data-type="number" data-field="engine" class="slider-price__input" id="slider-engine_min" name="pixad-engine">
							<span>-</span>
							<input data-type="number" data-field="engine" class="slider-price__input" id="slider-engine_max" name="pixad-engine">
							<input type="hidden" id="pix-min-engine" value="<?php echo isset($get_engine[0]) ? esc_attr($get_engine[0]) : ''; ?>">
							<input type="hidden" id="pix-max-engine" value="<?php echo isset($get_engine[1]) ? esc_attr($get_engine[1]) : ''; ?>">
							<input type="hidden" id="pix-max-slider-engine" value="7">
						</span>
					</div>
				</section>
			<?php
			}
			?>
			<?php
			if($instance['condition']) {
			?>
				<section class="widget block_content widget_mod-a pixad-filter" data-type="jelect" data-field="condition">
			<?php
				if (!empty($instance['condition_title'])) {
					echo $before_title . apply_filters('widget_title', $instance['condition_title']) . $after_title;
				}
				?>
					<div class="widget-content">
						<div  class="select select_mod-a jelect">
							<input data-type="jelect" data-field="condition" id="pixad-condition" name="pixad-condition" value="" data-text="imagemin" type="text" class="jelect-input">
							<div tabindex="0" role="button" class="jelect-current"><?php esc_html_e( 'All Conditions', 'pixautodeal') ?></div>
							<ul class="jelect-options">
								<li data-val="" class="jelect-option jelect-option_state_active"><?php esc_html_e( 'All Conditions', 'pixautodeal') ?></li>
								<li data-val="new" class="jelect-option"><?php esc_html_e( 'New', 'pixautodeal') ?></li>
								<li data-val="used" class="jelect-option"><?php esc_html_e( 'Used', 'pixautodeal') ?></li>
								<li data-val="driver" class="jelect-option"><?php esc_html_e( 'Driver', 'pixautodeal') ?></li>
								<li data-val="non driver" class="jelect-option"><?php esc_html_e( 'Non driver', 'pixautodeal') ?></li>
								<li data-val="projectcar" class="jelect-option"><?php esc_html_e( 'Projectcar', 'pixautodeal') ?></li>
								<li data-val="barnfind" class="jelect-option"><?php esc_html_e( 'Barnfind', 'pixautodeal') ?></li>
							</ul>
						</div>
					</div>
				</section>
			<?php
			}
			?>
		</div>

		<div class="btn">
			<div class="btn-filter wrap__btn-skew-r js-filter">
				<?php
					$path = '';
					if(substr_count($_SERVER['REQUEST_URI'], '/page/') > 0){
						$path = preg_split('/\/page\//', $_SERVER['REQUEST_URI']);
						$path = $path[0].'/';
					}else{
						$path = preg_split('/\?/', $_SERVER['REQUEST_URI']);
						$path = $path[0];
					}
				?>
				<button data-href="<?php echo esc_url($_SERVER['SERVER_NAME'] . $path)?>" id="pixad-reset-button" class="btn-skew-r btn-effect"><span class="btn-skew-r__inner"><?php echo wp_kses_post($instance['btn_title']) ?></span></button>

			</div>
		</div>

		<?php
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$price = isset( $instance['price'] ) ? $instance['price'] : 'on';
		$price_title = ! empty( $instance['price_title'] ) ? $instance['price_title'] : __( 'Price Range', 'pixautodeal' );
		$body = isset( $instance['body'] ) ? $instance['body'] : 'on';
		$body_title = ! empty( $instance['body_title'] ) ? $instance['body_title'] : __( 'Vehicle Body Type', 'pixautodeal' );
		$fuel = isset( $instance['fuel'] ) ? $instance['fuel'] : 'on';
		$fuel_title = ! empty( $instance['fuel_title'] ) ? $instance['fuel_title'] : __( 'Fuel Type', 'pixautodeal' );
		$mileage = isset( $instance['mileage'] ) ? $instance['mileage'] : 'on';
		$mileage_title = ( ! empty( $instance['mileage_title'] ) ) ? $instance['mileage_title'] : __( 'Mileage Range', 'pixautodeal' );
		$year = isset( $instance['year'] ) ? $instance['year'] : 'on';
		$year_title = ! empty( $instance['year_title'] ) ? $instance['year_title'] : __( 'Year Range', 'pixautodeal' );
		$transmission = isset( $instance['transmission'] ) ? $instance['transmission'] : 'on';
		$transmission_title = ! empty( $instance['transmission_title'] ) ? $instance['transmission_title'] : __( 'Transmission Type', 'pixautodeal' );
		$engine = isset( $instance['engine'] ) ? $instance['engine'] : 'on';
		$engine_title = ! empty( $instance['engine_title'] ) ? $instance['engine_title'] : __( 'Engine Volume', 'pixautodeal' );
		$condition = isset( $instance['condition'] ) ? $instance['condition'] : 'on';
		$condition_title = ! empty( $instance['condition_title'] ) ? $instance['condition_title'] : __( 'Condition', 'pixautodeal' );
		$btn_title = ! empty( $instance['btn_title'] ) ? $instance['btn_title'] : __( 'Filter Vehicles', 'pixautodeal' );

		?>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'price' ); ?>" name="<?php echo $this->get_field_name( 'price' ); ?>" type="checkbox" <?php checked( $price, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'price' ); ?>"><?php _e( 'Show Price Range:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'price_title' ); ?>"><?php _e( 'Price Block Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'price_title' ); ?>" name="<?php echo $this->get_field_name( 'price_title' ); ?>" type="text" value="<?php echo esc_attr( $price_title ); ?>">
		</p>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'body' ); ?>" name="<?php echo $this->get_field_name( 'body' ); ?>" type="checkbox" <?php checked( $body, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'body' ); ?>"><?php _e( 'Show Vehicle Body Type:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'body_title' ); ?>"><?php _e( 'Vehicle Body Type Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'body_title' ); ?>" name="<?php echo $this->get_field_name( 'body_title' ); ?>" type="text" value="<?php echo esc_attr( $body_title ); ?>">
		</p>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'fuel' ); ?>" name="<?php echo $this->get_field_name( 'fuel' ); ?>" type="checkbox" <?php checked( $fuel, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'fuel' ); ?>"><?php _e( 'Show Fuel Type:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'fuel_title' ); ?>"><?php _e( 'Fuel Type Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'fuel_title' ); ?>" name="<?php echo $this->get_field_name( 'fuel_title' ); ?>" type="text" value="<?php echo esc_attr( $fuel_title ); ?>">
		</p>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'mileage' ); ?>" name="<?php echo $this->get_field_name( 'mileage' ); ?>" type="checkbox" <?php checked( $mileage, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'mileage' ); ?>"><?php _e( 'Show Mileage Range:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'mileage_title' ); ?>"><?php _e( 'Mileage Block Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'mileage_title' ); ?>" name="<?php echo $this->get_field_name( 'mileage_title' ); ?>" type="text" value="<?php echo esc_attr( $mileage_title ); ?>">
		</p>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'year' ); ?>" name="<?php echo $this->get_field_name( 'year' ); ?>" type="checkbox" <?php checked( $year, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'year' ); ?>"><?php _e( 'Show Year Range:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'year_title' ); ?>"><?php _e( 'Year Range Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'year_title' ); ?>" name="<?php echo $this->get_field_name( 'year_title' ); ?>" type="text" value="<?php echo esc_attr( $year_title ); ?>">
		</p>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'transmission' ); ?>" name="<?php echo $this->get_field_name( 'transmission' ); ?>" type="checkbox" <?php checked( $transmission, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'transmission' ); ?>"><?php _e( 'Show Transmission Type:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'transmission_title' ); ?>"><?php _e( 'Transmission Type Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'transmission_title' ); ?>" name="<?php echo $this->get_field_name( 'transmission_title' ); ?>" type="text" value="<?php echo esc_attr( $transmission_title ); ?>">
		</p>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'engine' ); ?>" name="<?php echo $this->get_field_name( 'engine' ); ?>" type="checkbox" <?php checked( $engine, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'engine' ); ?>"><?php _e( 'Show Engine Volume:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'engine_title' ); ?>"><?php _e( 'Engine Volume Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'engine_title' ); ?>" name="<?php echo $this->get_field_name( 'engine_title' ); ?>" type="text" value="<?php echo esc_attr( $engine_title ); ?>">
		</p>
		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id( 'condition' ); ?>" name="<?php echo $this->get_field_name( 'condition' ); ?>" type="checkbox" <?php checked( $condition, 'on', true ); ?>>
			<label for="<?php echo $this->get_field_id( 'condition' ); ?>"><?php _e( 'Show Condition:' ); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'condition_title' ); ?>"><?php _e( 'Condition Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'condition_title' ); ?>" name="<?php echo $this->get_field_name( 'condition_title' ); ?>" type="text" value="<?php echo esc_attr( $condition_title ); ?>">
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'btn_title' ); ?>"><?php _e( 'Button Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'btn_title' ); ?>" name="<?php echo $this->get_field_name( 'btn_title' ); ?>" type="text" value="<?php echo esc_attr( $btn_title ); ?>">
		</p>
		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {

		$instance = array();
		$instance['price'] = $new_instance['price'];
		$instance['price_title'] = ( ! empty( $new_instance['price_title'] ) ) ? strip_tags( $new_instance['price_title'] ) : '';
		$instance['body'] = $new_instance['body'];
		$instance['body_title'] = ( ! empty( $new_instance['body_title'] ) ) ? strip_tags( $new_instance['body_title'] ) : '';
		$instance['fuel'] = $new_instance['fuel'];
		$instance['fuel_title'] = ( ! empty( $new_instance['fuel_title'] ) ) ? strip_tags( $new_instance['fuel_title'] ) : '';
        $instance['mileage'] = $new_instance['mileage'];
		$instance['mileage_title'] = ( ! empty( $new_instance['mileage_title'] ) ) ? strip_tags( $new_instance['mileage_title'] ) : '';
		$instance['year'] = $new_instance['year'];
		$instance['year_title'] = ( ! empty( $new_instance['year_title'] ) ) ? strip_tags( $new_instance['year_title'] ) : '';
		$instance['transmission'] = $new_instance['transmission'];
		$instance['transmission_title'] = ( ! empty( $new_instance['transmission_title'] ) ) ? strip_tags( $new_instance['transmission_title'] ) : '';
		$instance['engine'] = $new_instance['engine'];
		$instance['engine_title'] = ( ! empty( $new_instance['engine_title'] ) ) ? strip_tags( $new_instance['engine_title'] ) : '';
		$instance['condition'] = $new_instance['condition'];
		$instance['condition_title'] = ( ! empty( $new_instance['condition_title'] ) ) ? strip_tags( $new_instance['condition_title'] ) : '';

		$instance['btn_title'] = ( ! empty( $new_instance['btn_title'] ) ) ? strip_tags( $new_instance['btn_title'] ) : '';

		return $instance;
	}
}
/**
 * Register Widget
 *
 * @since 1.0
 */
function register_pixad_auto_filter_widgets() {
    register_widget( 'Pixad_Auto_Widget_By_Make' );
    register_widget( 'Pixad_Auto_Widget_Filter' );
    register_widget( 'Pixad_Auto_Widget_Year_Filter' );
    register_widget( 'Pixad_Auto_Widget_Price_Filter' );
    register_widget( 'Pixad_Auto_Widget_Body_Filter' );
    register_widget( 'Pixad_Auto_Widget_Fuel_Filter' );
    register_widget( 'Pixad_Auto_Widget_Transmission_Filter' );
    register_widget( 'Pixad_Auto_Widget_Mileage_Filter' );
    register_widget( 'Pixad_Auto_Widget_Engine_Filter' );
    register_widget( 'Pixad_Auto_Widget_Condition_Filter' );
    register_widget( 'Pixad_Auto_Widget_Reset_Button' );
}
add_action( 'widgets_init', 'register_pixad_auto_filter_widgets' );
?>